/* 
 * vim: set sw=8 ts=8 si et :
 * Copyright Guido Socher */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "i2c_m.h"


void help(){
	printf("i2ctemp_linux -- read values from the I2C termomether\n");
	printf("Usage: i2ctemp_linux [-h][-p device] \n");
	printf("Options: -h this help\n");
	printf("         -p set the port, default device is /dev/ttyS0\n");
	printf("\n");
	printf("The program prints any results on stdout.\n");
	exit(1);
}

int main(int argc, char **argv)
{
	/* The following things are used for getopt: */
	extern char *optarg;
	extern int optind;
	extern int opterr;
	char *port="/dev/ttyS0";
	int ch;
	char data[MAX_BUF_LEN+1];

	opterr = 0;
	while ((ch = getopt(argc, argv, "hp:")) != -1) {
		switch (ch) {
			case 'p':
				port = optarg;
				break;
			case 'h':
				help();
			case '?':
				fprintf(stderr, "ERROR: No such option. -h for help.\n");
				exit(1);
			/*no default action for case */
			}
	}
	if (optind != argc ){
		/* exactly no argument must be given */
		help();
	}

	/* open device */
	open_tty(port);
	// indoor sensor:
	if (!address_slave(3,0)){
		printf("ERROR: address_slave for write failed\n");
		i2cstop();
		close_tty();
		exit(1);
	}
	strcpy(data,"i");
	i2c_tx_string(data);
	i2cstop();
	//printf("In :");
	fflush(stdout);
	if (!address_slave(3,1)){
		printf("ERROR: address_slave for read failed\n");
		i2cstop();
		close_tty();
		exit(1);
	}
	i2c_rx_string(data);
	printf("%s\n",data);
	i2cstop();
	// outdoor sensor:
	if (!address_slave(3,0)){
		printf("ERROR: address_slave for write failed\n");
		i2cstop();
		close_tty();
		exit(1);
	}
	strcpy(data,"o");
	i2c_tx_string(data);
	i2cstop();
	//printf("Out:");
	fflush(stdout);
	if (!address_slave(3,1)){
		printf("ERROR: address_slave for read failed\n");
		i2cstop();
		close_tty();
		exit(1);
	}
	i2c_rx_string(data);
	printf("%s\n",data);
	i2cstop();
	close_tty();
	return(0);
}

